/**
 *
 * \file        hprfgw_rfPkt.h
 *
 * \brief       Defines the RF packets exchanged btw gateway and RF slave devices 
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        08/24/2006
 * \warning		
 * \note
 * \review	
 *
 * \Note	    (05/04/07) gateway host name size in Link reply packet increased 
 *						   parameters reorganized
 *						   The power level parameter size in the link request pkt
 *						   increased to 2-bytes.
 *
 */
#ifndef _HPRFGW_RFPKT_H_
	#define _HPRFGW_RFPKT_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfComLog.h"
#include "hprfgw_rfRec.h"

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////

//#define	RF_DEVICE_MAX_CRESNET_ID_STRING_LEN			70

////////////////////////////////////////////////////////////////////////////////
//	Data Prototypes	
////////////////////////////////////////////////////////////////////////////////

//	== MCP message sub-types Begin =================================
//	Gateway/RF device and internal packet list	
enum	{
	RF_PACKET_CRESNET = 1,				//	Cresnet packets from Control System/rf device to rf device/Control System	
	RF_PACKET_LOCAL_CRESNET,			//	Cresnet packets from gateway/rf device to rf device/gateway  
	RF_PACKET_CTLSYS_CONNECT_STATUS,	//	Control system connect/disconnect status packet sent to rf device
	RF_PACKET_HEART_BEAT,				//	Heart beat packet from rf device
	RF_PACKET_UNUSED1,					//	
	RF_PACKET_GATEWAY_RESTART,			//	Gateyway restart message

	//	Link packets
	RF_PACKET_LINK_REQUEST=20,			//	Link request packet from rf device
	RF_PACKET_LINK_REPLY,				//	Link reply from gateway (link accepted, rejected with reason)

	RF_PACKET_ENTER_SLEEP_STATE=25,		//	rf device sends this packet to gateway before entering sleep state
	RF_PACKET_ENTER_POWERDOWN_STATE,	//	rf device sends this packet to gateway before entering power down state

	//	device information strings
	RF_PACKET_DEVICE_DATA_FIELD_REQUEST=30,	//	Device data field information request 
	RF_PACKET_DEVICE_DATA_FIELD_REPLY,		//	Device data field information reply

	RF_PACKET_BUFFER_OVERFLOW_REPORT=40,//	transmitter/receiver buffer overflow counters reported to rf device 
	RF_PACKET_COMMUNICATION_ERROR,		//	Communication error packet	

	//	Communication test commands
	RF_PACKET_ECHO_REQUEST=50,			//	echo request command to/from gateway/rfdevice 
	RF_PACKET_ECHO_REPLY,				//	echo reply command to/from rfdevice/gateway
	RF_PACKET_THROUGHPUT_TST,			//	rf through-put test packet

	RF_PACKET_NETWORK_SERVICES,			//	network services
		RF_PACKET_DISCOVER_NETDEV_REQUEST=1,	//	discover devices on the network
		RF_PACKET_DISCOVER_NETDEV_REPLY=2,		//	
		RF_PACKET_REMOTE_SETUP=3,				//
		RF_PACKET_DISCOVER_NETDEV_BEACON=4,		//gateway to device, ervery 2.5secons
		RF_PACKET_DISCOVER_NETDEV_BEACON_REQ,      //device to gateway on power up
		RF_PACKET_DISCOVER_NETDEV_BEACON_REPLY,    //gateway to device respond to req.
		//	future expansions possibilties:
		//	1- remote setup (setrfid, lightbyuid, misc autodiscover functions...) 
		//	2- roaming tble query/reply/update

	//	Debug information request/reply
	RF_PACKET_DEBUG1_INFO_REQUEST=100,	//	debug1 information request from gateway
	RF_PACKET_DEBUG1_INFO_REPLY,		//	debug1 information reply to gateway  
	RF_PACKET_DEBUG2_INFO_REQUEST,		//	debug2 information request from gateway
	RF_PACKET_DEBUG2_INFO_REPLY,		//	debug2 information reply to gateway

	//	Internal packets (codes 240..250 are reserved for internal packets, exchanged btw the rf stack and HPRFGW application)
	RF_PACKET_ACTIVE_SCAN_REQUEST=240,	//	
	RF_PACKET_ACTIVE_SCAN_REPLY,		//	
	RF_PACKET_ENERGY_SCAN_REQUEST,		//	
	RF_PACKET_ENERGY_SCAN_REPLY,		//
	RF_PACKET_ASSOCIATE_REQUEST,		//	
	RF_PACKET_ASSOCIATE_REPLY,			//
	RF_PACKET_DISASSOCIATE_REQUEST,		//	
	RF_PACKET_DISASSOCIATE_REPLY,		//

	RF_PACKET_DISCARD=254				//	
};

//	CS status message flags	 
//#define	RF_PACKET_CTLSYS_CONNECT_CS_STATE 1		
#define	RF_PACKET_CTLSYS_ALL_CLEAR						2		
#define	RF_PACKET_CTLSYS_DATA_LEN						12

//	== MCP message sub-types End ==================================

//	== MLM message sub-types Begin ================================
//	Network commands btw gateway and RF Device  

//	== MLM message sub-types End ===========================

//	== ASP message sub-types Begin ================================
//	Commands btw RF Stack and gateway application (not sent over the air)

//	== ASP message sub-types End ===========================

//	== LOCAL message sub-types Begin ==============================
//	Commands btw RF transmit task and other application tasks 

//	== LOCAL message sub-types End =========================

///////////////////////////////////////////////////////////////////////////////////////////////////////

// ==== RF packet headers structure parameters ======================
//	RF device packet Header option flags used in the RF packet header
#define	RF_HEADER_EXPANSION_NOTUSED_B0			01		//	Not assigned 			
#define	RF_HEADER_EXPANSION_NOTUSED_B1			02		//	Not assigned 		
#define	RF_HEADER_EXPANSION_NOTUSED_B2			04		//	Not assigned 		
#define	RF_HEADER_EXPANSION_NOTUSED_B3			08		//	Not assigned 		
#define	RF_HEADER_EXPANSION_CS_CONNECT_STATE	16		//	Set if CS connected and is polling gateway	
#define	RF_HEADER_EXPANSION_CRESNET_NET			32		//	Set if Cresnet present
#define	RF_HEADER_EXPANSION_ETHERNET_NET		64		//	Set if Ethernet connected			
#define	RF_DEVICE_TYPE_GATEWAY					128		//	Set if packet transmitted from gateway

//	Header for each RF transmit payload data (there is one header for each payload packet) 
#define	HPRFGW_PACKET_SIGNATURE	0x4853
typedef	struct	{
	UINT8	linkquality;	
	UINT8	sequence;
	UINT16	signature;
}	TYPE_RF_PAYLOAD_HEADER;

//	RF packet header (each RF packet has a header e.g. [pktHdr][Cresnetpkthdr+PayLoad][Cresnetpkthdr+Payload]) 
//	the rf packet header is transmitted in this format over the air
typedef	struct	{
	UINT8	length;
	UINT8	type;
	UINT8	totalsegments;
	UINT8	segmentno;
	UINT8	options;
}	TYPE_EXTERNAL_RF_PACKET_HEADER;

//	The rf packet header is manipulated in this format internally, which allowes the length to be 2-bytes
//	the segmented packets data and header length could be larger than 255 bytes. however, over the air
//	only a maximum size of 127 bytes could be transfered which includs the IEEE header 
typedef	struct	{
	UINT16	length;			 
	UINT8	type;
	UINT8	totalsegments;
	UINT8	segmentno;
	UINT8	options;
}	TYPE_INTERNAL_RF_PACKET_HEADER;

// ==== RF buffer overflow packet data structure parameters ===================
typedef	struct	{
	UINT8	transmitpipeoverflow;	
	UINT8	receivepipeoverflow;	
	UINT8	unused[16];
}	TYPE_RF_BUFFER_OVERFLOW_PACKET_DATA;	

// ==== RF commuication packet data structure parameters ===================
#define	RF_COMM_ERR_PACKET_NONE						0
#define	RF_COMM_ERR_PACKET_OUT_OF_SEQUENCE			1
#define	RF_COMM_ERR_SEGMENT_OUT_OF_SEQUENCE			2
#define	RF_COMM_ERR_SEGMENT_LEN_TOO_BIG				4
#define	RF_COMM_ERR_SEGMENT_MISSING					8
#define	RF_COMM_ERR_SEGMENT_LEN_SHORT				16								

#define	RF_COMMUNICATION_ERROR_PACKET_UNUSED_DATA_LEN	10
typedef	struct	{
	UINT16	flags;
	UINT8	expectedsequenceno;	
	UINT8	receivedsequenceno;		
	
	UINT8	totalsegments;	
	UINT8	expectedsegment;	
	UINT8	receivedsegment;		
		
	UINT8	unused[RF_COMMUNICATION_ERROR_PACKET_UNUSED_DATA_LEN];	
}	TYPE_RF_COMMUNICATION_ERROR_PACKET_DATA;	

// ==== Control System Status packet data structure parameters ===================
typedef	struct	{
	UINT8	status[8];		
}	TYPE_RF_CS_STATUS_PACKET_DATA;	

// ==== ID String Change Report ==================================================
typedef	struct	{
	UINT8	rfid;
	UINT32	tsid;
	UINT8	idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];		
}	TYPE_RF_ID_STRING_PACKET_DATA;	

// ==== Debug1 request/reply packet data structure parameters ====================
typedef	struct	{
	UINT8	command;	
	UINT8	options;
}	TYPE_RF_DEBUG1_REQUEST_PACKET_DATA;	

#define	RF_DEBUG1_PACKET_DATA_LEN	10
typedef	struct	{
	UINT8	command;	
	UINT8	options;
	UINT8	data[10];
}	TYPE_RF_DEBUG1_REPLY_PACKET_DATA;	

// ==== Echo request/reply packet data structure structure parameters ====================
#define	RF_ECHO_PACKET_DATA_LEN			200
typedef	struct	{
	UINT8	linkquality;
	UINT8	data[RF_ECHO_PACKET_DATA_LEN];	
}	TYPE_RF_ECHO_REQUEST_PACKET_DATA;	

//	Echo reply packet data structure	   
typedef	struct	{
	UINT8	linkquality;
	UINT8	data[RF_ECHO_PACKET_DATA_LEN];
}	TYPE_RF_ECHO_REPLY_PACKET_DATA;	

// ==== RF through-put test packet data structure parameters =============================
#define	RF_THROUGHPUT_PACKET_DATA_LEN	200
typedef	struct	{
	UINT8	data[RF_THROUGHPUT_PACKET_DATA_LEN];
}	TYPE_RF_THROUGHPUT_PACKET_DATA;	

// ==== Entering sleep mode packet data structure parameters ====================
#define	RF_SLEEP_PACKET_DATA_LEN		8
typedef	struct	{
	UINT8	data[RF_SLEEP_PACKET_DATA_LEN];
}	TYPE_RF_SLEEP_PACKET_DATA;	

// ==== Entering power down mode packet data structure parameters ===============
#define	RF_POWERDOWN_PACKET_DATA_LEN	8
typedef	struct	{
	UINT8	data[RF_POWERDOWN_PACKET_DATA_LEN];
}	TYPE_RF_POWERDOWN_PACKET_DATA;	

// ==== RF Device Heart Beat packet data structure parameters ====================
#define	RF_HEART_BEAT_PACKET_DATA_LEN	8
typedef	struct	{
	UINT8	linkquality;
	UINT8	unused[RF_HEART_BEAT_PACKET_DATA_LEN];
}	TYPE_RF_HEART_BEAT_PACKET_DATA;	

// ==== RF Device Data Field packet data request/reply structure parameters =======
typedef	struct	{
	UINT8	field;
	UINT32	unused;
}	TYPE_RF_DEVICE_FIELD_PACKET_DATA_REQUEST;	

#define	RF_DEVICE_DATA_FIELD_MAX_SIZE	250
typedef	struct	{
	struct {
		UINT8	field;
		UINT16	crc;
		UINT32	unused;
	}	hdr;
	INT8	data[RF_DEVICE_DATA_FIELD_MAX_SIZE];
}	TYPE_RF_DEVICE_FIELD_PACKET_DATA_REPLY;	

// ==== RF Device Link Request/Reply packet data structure parameters ====================
//	bits defined in the flags field	 
#define	ACQUIRE_ACTIVE			1		//	1=acquire running
#define	ACQUIRE_SUCCESSFUL		2		//	1=device was successful acquired
//#define	UNUSED				4...128	//	future

//	Link request packet link condition parameters
#define	RF_PACKET_LINK_UNCONDITIONAL					0
#define	RF_PACKET_LINK_ONLY_IF_GATEWAY_IN_ACQUIRE		1
#define	RF_PACKET_LINK_QUERY							2

typedef	struct	{
	UINT8	flags;
	UINT8	linkcondition;
	UINT8	deviceoptions;
	UINT16	randomno;
	UINT8	power;
	UINT8	rfid;
	UINT32	tsid;
	UINT16	panid;	
	UINT8	idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];	
}	TYPE_RF_LINK_REQUEST_PACKET_DATA;	

//	Link reply packet sub-parameters (link rejection/acceptace reasons)
#define	RF_PACKET_LINK_SUCCESSFUL_NEW_ENTRY				1
#define	RF_PACKET_LINK_SUCCESSFUL_EXISTING_ENTRY		2
#define	RF_PACKET_LINK_REJECTED_DESCRIPTOR_TABLE_FULL	3	//	not supported
#define	RF_PACKET_LINK_REJECTED_DUPLICATE_UID			4	
#define	RF_PACKET_LINK_REJECTED_DISABLED				5
#define	RF_PACKET_LINK_REJECTED_NOT_IN_ACQUIRE			6	
#define	RF_PACKET_LINK_REJECTED_DEVICE_NOT_LINKED		7	
#define	RF_PACKET_LINK_REJECTED_UNKNOWN_LINK_CONDITION	8
#define	RF_PACKET_LINK_QUERY_REPLY						9	

//	RF Device Link Reply packet data structure	   
#define	RF_LINK_REPLY_PACKET_DATA_LEN	8
typedef	struct	{
	UINT8	linkresultcode;
	UINT16	randomno;	
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;
	UINT8	addrmode;
	UINT8	linkquality;
	UINT8	power;
	UINT8	cnetid;
	UINT32	tsid;	
	UINT8	unused[RF_LINK_REPLY_PACKET_DATA_LEN];	
	UINT8	gatewayname[GATEWAY_NAME_MAX_SIZE];
}	TYPE_RF_LINK_REPLY_PACKET_DATA;	

// ==== Gateway restart message packet data structure parameters ===============
#define	RF_GATEWAY_RESTART_PACKET_DATA_LEN	16
typedef	struct	{
	UINT32	flags;
	UINT8	data[RF_GATEWAY_RESTART_PACKET_DATA_LEN];
}	TYPE_RF_GATEWAY_RESTART_PACKET_DATA;	

// ==== Gateway restart message packet data structure parameters ===============
#define	RF_DISCOVER_REQUEST_PACKET_DATA_LEN	10	

//	request command flags
#define	RF_DISCOVER_GATEWAYS				1	
#define	RF_DISCOVER_SLAVES					2
typedef	struct	{
	UINT32	flags;
	UINT32	unused[4];
	UINT8	data[RF_DISCOVER_REQUEST_PACKET_DATA_LEN];
}	TYPE_RF_DISCOVERY_REQUEST_PACKET_DATA;

//	RF discover packet reply field flag definitions
#define	RFDISCOVER_MASTER_MODE_FLAG	1
#define	RFDISCOVER_IN_ACQUIRE_FLAG	2
typedef	struct	{
	UINT32	flags;	
	UINT32	unused;	
	UINT8	rfid;
	UINT32	tsid;
	UINT16	power;
	UINT8	linkquality;
	UINT8	name[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
	UINT8	gatewayuid[UID_MAX_SIZE];
	UINT16	gatewaypanid;
}	TYPE_RF_DISCOVERY_REPLY_PACKET_DATA;

#define	RF_REMOTE_SETUP_PACKET_DATA_LEN	16	
// flags
#define RF_REMOTE_NET_CONNECT		1
#define	RF_REMOTE_NET_DEFAULT		2
#define	RF_REMOTE_NET_DISCONNECT	4
typedef	struct	{
	UINT32	flags;
	UINT32	unused;
	UINT8	gatewayuid[UID_MAX_SIZE];
	UINT16	gatewaypanid;
	UINT8	gatewayaddrmode;
	UINT8	deviceuid[UID_MAX_SIZE];
	UINT16	devicepanid;
	UINT8	deviceaddrmode;
	UINT8	data[RF_REMOTE_SETUP_PACKET_DATA_LEN];
}	TYPE_RF_REMOTE_SETUP_PACKET_DATA;

#define	RF_BEACON_PACKET_DATA_LEN	20
typedef	struct	{
	UINT32	flags;
	UINT32	lqi;
	UINT8	data[RF_BEACON_PACKET_DATA_LEN];
}	TYPE_RF_BEACON_PACKET_DATA;

typedef	struct	{
	UINT8	msgtype;
	UINT32	unused;	
	union {
		TYPE_RF_DISCOVERY_REQUEST_PACKET_DATA	adreq;	
		TYPE_RF_DISCOVERY_REPLY_PACKET_DATA		adreply;
		TYPE_RF_REMOTE_SETUP_PACKET_DATA		rmts;
		TYPE_RF_BEACON_PACKET_DATA				beacon;
	}	pkt;	
}	TYPE_RF_NETWORK_SERIVCES_PACKET_DATA;

// ==== Active scan reply structure ===================
#define	RF_ACTIVE_SCAN_MAX_PAN_DESCRIPTORS	10
typedef	struct	{
	UINT8	noofdescriptors;		
	panDescriptor_t pandesc[RF_ACTIVE_SCAN_MAX_PAN_DESCRIPTORS];
}	TYPE_RF_ACTIVE_SCAN_REPLY_PACKET_DATA;	

// ==== Energy scan reply structure ===================
typedef	struct	{
	UINT8	EnergyLevel[gLogicalChannel26_c-gLogicalChannel11_c+1]; 
}	TYPE_RF_ENERGY_SCAN_REPLY_PACKET_DATA;	

////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////


#endif
/**/
